
#include <arduino.h>
#include <stdio.h> 
#include <stdarg.h>

#ifndef PARSECMD_h
#define PARSECMD_h
  
#define RX_BUFFER_LEN 300           // recieve buffer length
#define LINE_LEN 128                // line buffer length
#define TITAL_LEN 26                // tital buffer length
#define defaultDelimTime 1200        // default delimiter time(us)
#define defaultMaxResponeTime 100   // default maxinum command response time(ms)
#define cmdSpTime 5                 // maxinum command response time(ms)  

class parsecmd{
private:
    Stream * _serial;
    char rxBuffer[RX_BUFFER_LEN];
    int bH;         // buffer head pointer
    char aLine[LINE_LEN];
    char titleStr[TITAL_LEN];
    char delim[6];
    int srchHp;     // search head pointer
public:
    parsecmd(){parsecmd();};
    parsecmd(Stream &srl);
    ~parsecmd(){};
    void begin(Stream &srl);
    int listen(uint16_t maxResponeTime=defaultMaxResponeTime,uint16_t delimiterTime=defaultDelimTime);
    int readyForResponse(const char *pass,unsigned long waitTime=100);                      // return 0: no responed & time-out, 1: respone "pass"
    int readyForResponse(const char *pass,const char *fail,unsigned long waitTime=100);     // return 0: no responed & time-out, 1: respone "pass", -1: respone "fail"   
    int getResponse(const char *pass,uint16_t maxResponeTime=defaultMaxResponeTime);        // return 0: no responed & time-out, 1: respone "pass"
    int getNextResponse(const char *pass,uint16_t maxResponeTime=defaultMaxResponeTime);                                                  // return 0: no responed & time-out, 1: respone "pass"
    int getNextResponse(uint16_t maxResponeTime=defaultMaxResponeTime);
    int getResponse(const char *pass,const char *fail,uint16_t maxResponeTime=defaultMaxResponeTime); // return 0: no responed & time-out, 1: respone "pass", -1: respone "fail"
    int getResponse(uint16_t maxResponeTime=defaultMaxResponeTime);
    char *searchBuffer(const char *pattern);
    char *searchTitle(const char *title); 
    char *searchNextTitle(const char *title); 
    char *searchNextTitle();
    char *getTitle(); 
    char *getNextTitle();
    char *getParam(const char *dlm);
    char *nextParam(const char *dlm); 
    char *nextParam();
    void clearBuffer();
    void flush();
    void send(char *fmt,...);
    void cSend(char *fmt,...);
};

typedef class parsecmd PCMD;

unsigned long differentTime(unsigned long s1,unsigned long s2);

#endif /* PARSECMD_h */
