
#include <arduino.h>
#include <string.h>
#include "nbiot.h"
#include "DEBUG.h"
#include "difftime.h"   
#include <U8g2lib.h>
#include <Wire.h>
#include "sleepX.h"
#include <RTClock.h>

#define LED PB12  // low 時,LED亮

#define devRst PC13
#define devRstLow digitalWrite(devRst,LOW)
#define devRstHigh digitalWrite(devRst,HIGH)
#define ledOn() digitalWrite(LED,LOW)
#define ledOff() digitalWrite(LED,HIGH)
#define ledInit() pinMode(LED,OUTPUT_OPEN_DRAIN) 

nbIOT mqt(Serial1);
U8G2_SSD1306_128X64_NONAME_F_SW_I2C u8g2(U8G2_R0,PB6, PB7, U8X8_PIN_NONE); // 設定OLED

RTClock rt(RTCSEL_LSE);
SleepX pm(&rt);

long int sleepTime = 180;        // sleep 30 seconds

int icnt;

void setup(void) {
    // 設定LED
    ledInit();
    pinMode(devRst,OUTPUT);

    Serial.begin(115200);              // 設定host serial for debug or monitor
    Serial1.begin(115200);             // 設定MQTT serial for MQTT

    u8g2.begin();
    u8g2.disableUTF8Print();            // enable UTF8 support for the Arduino print() function
    u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
    u8g2.setFontDirection(0);

    ledOff();
    devRstHigh;
    delay(300);
    devRstLow;
    delay(500);
    devRstHigh;
    delay(1000);
    mqt.flush();

    int errCode;
    showMessage(0,0,"Setup network!!");
    ledOn();
    if (errCode = mqt.setupNetwork("internet.iot","1,8")){        // return 1 if error
        showMessage(0,0,"Setup Network Error %d .",errCode);
    }else{
        beginShow;
            lineShow(0,"Setup Network Ok!!");
            lineShow(1,"delay 8 sec");
        endShow;
        delay(8000);
    }
      
    if ((errCode = mqt.checkNetwork())!=0) {
        showMessage(0,0,"Check Network Error %d .",errCode);
    }else{
        showMessage(0,0,"Network working good");
    }
    
    ledOff();

    mqt.setupServer("XYZ.com.tw","tom","11223344","NBIOT002",15);    // 設定連接 boker 網名/IP,使用者名稱,密碼,設備名稱,網路連接持續時間(秒)
      
    icnt=0;
}

char topic[20];
char payload[128];
int errCode;

void loop(void) {
    ledOn();
    if ((errCode = mqt.start())!=0) {              // 若無連接上,顯示訊息在OLED上
        beginShow;
            lineShow(0,"Connect MQTT server");
            lineShow(1,"Error %d .",errCode);
            lineShow(2,"Sleep %d sec",sleepTime);
        endShow;
        mqt.cSend("AT+QSCLK= 1");                   // 啟動NBIOT計時,若無連接進入sleep
        mqt.flush();                                // 清空接受BC660的buffer
    }else{
      beginShow;                                    // 連接上boker,並進行傳訊
      lineShow(0,"Connect MQTT Ok");
      goShow;
      mqt.sub("H_NTP_CLOCK/Time");
      mqt.sub("pub_icnt");
        
      int line = 1;   
      unsigned long subTime=millis();
     
      if (mqt.getSub(topic,payload,2000)){
        lineShow(line,"<%s:%s",topic,payload);
        goShow;
        line++;
        while (mqt.getNextSub(topic,payload)){
          lineShow(line,"<%s:%s",topic,payload);
          goShow;
          line++;
        }
      };
        
      errCode=mqt.pub("pub_icnt",String(icnt).c_str());
      if (errCode==0){
        lineShow(line,">pub_icnt %d ok",icnt);
        goShow;
        line++;
        icnt++;
      } else {
        lineShow(line,">pub_icnt %d fail",icnt);
        goShow;
        line++;
      }
        
      if (mqt.getSub(topic,payload,1000)){
        lineShow(line,"<%s:%s",topic,payload);
        goShow;
        line++;
        while (mqt.getNextSub(topic,payload)){
          lineShow(line,"<%s:%s",topic,payload);
          goShow;
          line++;
        }
      };
      
      mqt.flush();
      mqt.end();                                // 結束mqtt各項工作,BC660進入倒數計時sleep
      lineShow(line,"Sleep %d sec",sleepTime);
      goShow;
      endShow;
    }
    ledOff();
    Serial1.end();
    pm.sleep(sleepTime);                        // MCU 進入sleep mode 
    Serial1.begin(115200);
    mqt.flush();
    showMessage(5,2,"Wake up");
    mqt.wakeUp();
    
}
