

//#include "DEBUG.h"
#include "parsecmd.h"
#include <string.h>
#include "difftime.h"

parsecmd::parsecmd(Stream &srl){
    begin(srl);
}

void parsecmd::begin(Stream &srl){
    _serial = &srl;
    clearBuffer();
}

// return nono zero is finish recieved or return 0 is timeout & not recieved any data 
// maxResponeTime's unit is mini-second
// delimiterTime's unit is micro-second  
int parsecmd::listen(uint16_t maxResponeTime,uint16_t delimiterTime){
    unsigned long startTimeStamp=millis();
    while (_serial->available() == 0){                                          // 若無資料進來
        if (differentTime(startTimeStamp,millis())>maxResponeTime) return 0;    // 檢查是否反應超時 
    }

    uint8_t b;
    startTimeStamp=micros();
    int oldBh = bH;
    do {
        if (_serial->available()){                                                  
            b=_serial->read();
            rxBuffer[bH]=b;
            bH++;
            startTimeStamp=micros();
        };
    }while (differentTime(startTimeStamp,micros())< delimiterTime && (bH<(RX_BUFFER_LEN-1)) );     
    
    rxBuffer[bH]=0;
    bH++;

    char p;
    int i;
    for(i=oldBh;i<bH;i++){     
        p=rxBuffer[i];
        if (p=='\n' || p=='\r') rxBuffer[i]=0;
    }   
    
    if (bH >= (RX_BUFFER_LEN-1)) bH = RX_BUFFER_LEN;
    return bH-oldBh;               
}


int parsecmd::readyForResponse(const char *pass,unsigned long waitTime) 
{  
    int received=0;
    unsigned long tTimeStamp=millis();
    do{
        if (0!=listen(cmdSpTime)) received++; 
    }while(differentTime(tTimeStamp,millis())<waitTime);
    
    if (received==0) return 0;
    if (0!=searchBuffer(pass)) return 1;
    return 0;                 
}

int parsecmd::readyForResponse(const char * pass, const char * fail,unsigned long waitTime) 
{
    int received=0;       // received keeps track of number of chars read  
    unsigned long tTimeStamp=millis();
    do{
        if (0!=listen(cmdSpTime)) received++; 
    }while(differentTime(tTimeStamp,millis())<waitTime);
    
    if (received==0) return 0;
    if (0!=searchBuffer(pass)) return 1;               
    if (0!=searchBuffer(fail)) return -1;
    return 0;
}

int parsecmd::getResponse(const char *pass,uint16_t maxResponeTime){
    if (listen(maxResponeTime)==0) return 0;
    if (0!=searchTitle(pass)) return 1;
    return 0;
}

/**
 * Retrieves the next command from the parsed command line.
 *
 * @return 1 if a command was successfully retrieved, 0 otherwise.
 */
int parsecmd::getNextResponse(uint16_t maxResponeTime){
    listen(maxResponeTime);
    if (0!=searchNextTitle()) return 1;
    return 0;
}

int parsecmd::getNextResponse(const char *pass,uint16_t maxResponeTime){
    listen(maxResponeTime);
    if (0!=searchNextTitle(pass)) return 1;
    return 0;
}

int parsecmd::getResponse(uint16_t maxResponeTime){
    if (listen(maxResponeTime)==0) return 0;
    return 1;
}

/**
 * Retrieves the response from the command.
 *
 * @param pass The pass string to search for in the response.
 * @param fail The fail string to search for in the response.
 * @param maxResponeTime The maximum time to wait for the response.
 *
 * @return 1 if the pass string is found in the response, -1 if the fail string is found in the response,
 *         0 if neither the pass nor the fail string is found in the response, or if the response is not received within the specified time.
 *
 * @throws None.
 */
int parsecmd::getResponse(const char *pass,const char *fail,uint16_t maxResponeTime){
    if (listen(maxResponeTime)==0) return 0;
    if (0!=searchTitle(pass)) return 1;
    if (0!=searchTitle(fail)) return -1;
    return 0;
}

/**
 * Searches the rxBuffer for a pattern and returns a pointer to the first occurrence.
 *
 * @param pattern The pattern to search for in the rxBuffer.
 *
 * @return A pointer to the first occurrence of the pattern in the rxBuffer, or 0 if the pattern is not found.
 *
 * @throws None.
 */
char *parsecmd::searchBuffer(const char *pattern)
{
    int srchHp = 0;
    char *sp;
    char *sHp;
    while (rxBuffer[srchHp]==0 && (srchHp < (bH-1))) srchHp++;
    sp=0;
    while (srchHp<(bH-1) ){
        sHp = &rxBuffer[srchHp];
        sp=strstr(sHp,pattern);
        if (sp!=0) break;
        srchHp = srchHp + strlen(sHp);
        while (rxBuffer[srchHp]==0 && (srchHp < (bH-1))) srchHp++;
    } 
    if (sp==0) return 0;
    return sHp;
}

/**
 * Searches the buffer for the specified title and returns the current line 
 * (including the title) if found. Returns 0 if the title is not found.
 *
 * @param title The title to search for in the buffer.
 *
 * @return A pointer to the current line (including the title) if found, 
 *         otherwise 0.
 *
 * @throws None
 */
char *parsecmd::searchTitle(const char *title)                  // 在暫存區找到所要標題列,返回現在的列(包含標題)
{                                                               // 返回零,未找到標題
    srchHp = 0;
    char *sp;
    char *sHp;
    char *tHp;
    strcpy(titleStr,title);
    while ((rxBuffer[srchHp]==0 || rxBuffer[srchHp]==' ') && (srchHp < (bH-1))) srchHp++; // 跳過空白,直到找到第一個字元
    while (srchHp<(bH-1) ){                                     
        sHp = &rxBuffer[srchHp];
        strcpy(aLine,sHp);
        tHp=strtok(aLine," ");
        srchHp = srchHp + strlen(sHp);
        while ((rxBuffer[srchHp]==0 || rxBuffer[srchHp]==' ') && (srchHp < (bH-1))) srchHp++; // 跳過空白,直到找到第一個字元
        if (0==strcmp(tHp,title)) return sHp;
    } 
    return 0;
}

/**
 * Searches for the next title in the rxBuffer.
 *
 * @return A pointer to the current line (including the title) if a title is found,
 *         otherwise 0.
 *
 * @throws None
 */
char *parsecmd::searchNextTitle(){
    char *sp;
    char *sHp;
    char *tHp;
    while ((rxBuffer[srchHp]==0 || rxBuffer[srchHp]==' ') && (srchHp < (bH-1))) srchHp++; // 跳過空白,直到找到第一個字元
    while (srchHp<(bH-1) ){
        sHp = &rxBuffer[srchHp];
        strcpy(aLine,sHp);
        tHp=strtok(aLine," ");
        srchHp = srchHp + strlen(sHp);
        while ((rxBuffer[srchHp]==0 || rxBuffer[srchHp]==' ') && (srchHp < (bH-1))) srchHp++; // 跳過空白,直到找到第一個字元
        if (0==strcmp(tHp,titleStr)) return sHp;
    }
    return 0;
}

char *parsecmd::searchNextTitle(const char *title){
    char *sp;
    char *sHp;
    char *tHp;
    strcpy(titleStr,title);
    while ((rxBuffer[srchHp]==0 || rxBuffer[srchHp]==' ') && (srchHp < (bH-1))) srchHp++; // 跳過空白,直到找到第一個字元
    while (srchHp<(bH-1) ){
        sHp = &rxBuffer[srchHp];
        strcpy(aLine,sHp);
        tHp=strtok(aLine," ");
        srchHp = srchHp + strlen(sHp);
        while ((rxBuffer[srchHp]==0 || rxBuffer[srchHp]==' ') && (srchHp < (bH-1))) srchHp++; // 跳過空白,直到找到第一個字元
        if (0==strcmp(tHp,title)) return sHp;
    }
    return 0;
}

char *parsecmd::getTitle(){
    srchHp = 0;
    return getNextTitle();
}

char *parsecmd::getNextTitle(){
    char *sp;
    char *sHp;
    char *tHp;
    while ((rxBuffer[srchHp]==0 || rxBuffer[srchHp]==' ') && (srchHp < (bH-1))) srchHp++; // 跳過空白,直到找到第一個字元
    while (srchHp<(bH-1) ){                                     
        sHp = &rxBuffer[srchHp];
        strcpy(aLine,sHp);
        tHp=strtok(aLine," ");
        srchHp = srchHp + strlen(sHp);
        while ((rxBuffer[srchHp]==0 || rxBuffer[srchHp]==' ') && (srchHp < (bH-1))) srchHp++; // 跳過空白,直到找到第一個字元
        if ((*tHp)=='+') return tHp;
    } 
    return 0;
}
/**
 * Retrieves the next parameter from the delimiter-separated string.
 *
 * @param dlm The delimiter string used to separate the parameters.
 *
 * @return A pointer to the next parameter in the delimiter-separated string, or nullptr if there are no more parameters.
 *
 * @throws None
 */
char *parsecmd::getParam(const char *dlm){
    return nextParam(dlm);
}

/**
 * Retrieves the next parameter from the delimiter-separated string.
 *
 * @param dlm The delimiter string used to separate the parameters.
 *
 * @return A pointer to the next parameter in the delimiter-separated string.
 *
 * @throws None
 */
char *parsecmd::nextParam(const char *dlm){
    strcpy(delim,dlm);
    char *rlt;
    rlt = strtok(NULL,delim);
    return rlt;    
}

/**
 * Retrieves the next parameter from the delimiter-separated string.
 *
 * @return The next parameter from the delimiter-separated string.
 *
 * @throws None
 */
char *parsecmd::nextParam(){
    char *rlt;
    rlt = strtok(NULL,delim);
    return rlt;
}

/**
 * Clears the buffer by resetting the head and start indices to 0, and setting the first element of the buffer to 0.
 *
 * @throws None
 */
void parsecmd::clearBuffer()
{
  //memset(rxBuffer, '\0', RX_BUFFER_LEN);
    bH = 0;
    srchHp = 0;
    rxBuffer[0]=0;
} 

/**
 * Flushes the serial connection by reading any available data and then clearing the buffer.
 *
 * @throws None
 */
void parsecmd::flush(){
    while (_serial->available()) _serial->read();
    clearBuffer();
}

/**
 * Sends formatted data over the serial connection.
 *
 * @param fmt The format string for the data
 *
 * @return None
 *
 * @throws None
 */
void parsecmd::send(char *fmt,...){
    char sbuf[80];
    va_list ap;
    va_start(ap, fmt);
    vsprintf(sbuf, fmt, ap);
    va_end(ap);
    //DBG(sbuf);
    _serial->println((String)sbuf);
}

/**
 * Sends formatted data over the serial connection.
 *
 * @param fmt The format string for the data
 *
 * @throws None
 */
void parsecmd::cSend(char *fmt,...){
    flush();
    char sbuf[80];
    va_list ap;
    va_start(ap, fmt);
    vsprintf(sbuf, fmt, ap);
    va_end(ap);    
    //DBG(sbuf);
    _serial->println((String)sbuf);
}
