
#include <Arduino.h>
#include <string.h>
#include "parsecmd.h"

#ifndef _NBIOT_H_
#define _NBIOT_H_

#define nbPnt(X) _serial->println(X)
#define nbSetBps(X) nbPnt((String)"AT+IPR="+X)                              // nbiot 本身串列埠速率設定  (AT+IPR=115200)  (AT+IPR=115200")                                    // nbiot 本身串列埠速率設定
#define nbAT() nbPnt("AT")                                                  // nbiot AT command
#define nbRSSI() nbPnt("AT+CSQ")                                            // return Received signal strength indication
#define nbRadioCntStates() nbPnt("AT+CSCON?")                               // This command gives details of the TA’s perceived radio connection status (i.e. with a base station). I  
#define nbSetBand(X) nbPnt((String)"AT+QBAND="+X)                           // nbiot使用的頻道
#define nbIpName(X) nbPnt((String)"AT+QCGDEFCONT=\"IP\",\""+X+"\"")         // 設定APN IP 網路名稱
#define nbLedMode1 nbPnt("AT+QLEDMODE=1")                                   // 設定network LED燈的模式
#define nbRst nbPnt("AT+QRST=1")                                            // 快速重罝並連接基地台,取得IP地址
#define nbLowPower nbPnt("AT+CFUN=0")                                       // nbiot 進入低功耗 
#define nbFullPower nbPnt("AT+CFUN=1")                                      // nbiot 全功率模式
#define nbNetworkRegState nbPnt("AT+CEREG?")                                // 詢問網路是否註冊
#define nbNetworkIpAddress nbPnt("AT+CGPADDR?")                             // 詢問IP位址
#define nbNonSleep nbPnt("AT+QSCLK=0")                                      // 禁止Sleep
#define nbEnDeepSleep nbPnt("AT+QSCLK=1")                                   // 允許進入light sleep & deep sleep
#define nbEeLightSleep nbPnt("AT+QSCLK=2")                                  // 允許進入light sleep

#define nbMqttConnect(X,Y) nbPnt((String)"AT+QMTOPEN=0,\""+X+"\",\""+Y+"\"")                // 設定MQTT boker IP 位址及埠號
#define nbMqttLogin(X,Y,Z) nbPnt((String)"AT+QMTCONN=0,\""+X+"\",\""+Y+"\",\""+Z+"\"")      // 設定MQTT X:設備ID Y:使用者名稱 Z:密碼
#define nbMqttClose() nbPnt("AT+QMTCLOSE=0")                                                // 結束MQTT連線

#define nbMqttPub(X,Y) nbPnt((String)"AT+QMTPUB=0,"+mID+",2,1,\""+X+"\","+strlen(Y)+",\""+Y+"\"");mID++     // publish X:Topic Y:value
#define nbMqttSub(X) nbPnt((String)"AT+QMTSUB=0,"+mID+",\""+X+"\",2");mID++                      // subscription X:Topic


#define cmdSpTime 20               // maxinum command response time 20ms  

#define apnCennectTimeUp 10000
#define mqttConnectTimeUp 8000
#define mqttLoginTimeUp 9000
#define mqttLoopTimeUp 1000         // 1 second
#define okTimeUp 200
#define qmtTimeUp 5000
#define defaultMaxResponeTime 2

#define _selBps 115200
#define delimTime 8000

#define apnNameX "internet.iot"         // 電信公司APN設定
#define bandNameX "1,8"                 // 電信公司NBIOT使用頻段字串

#define mqttIpX "youlight.com.tw"       // MQTT server IP or donename    
#define mqttPortX 1883                  // MQTT port number(字串)
#define mqttUserNameX "TEST"            // MQTT 使用者名稱
#define mqttPassWordX "1357AAAA"        // MQTT 使用者密碼
#define deviceIdX "TEST2022"            // 設備ID

#define MQTT_TCP_ID 0

class nbiot : public parsecmd {
private:
    char apnName[20];                      // 電信公司APN設定
    char bandName[20];                     // 電信公司NBIOT使用頻段字串
    char mqttIP[40];                       // MQTT server IP or donename
    uint16_t mqttPort;                     // MQTT port number
    char mqttUserName[40];                 // MQTT 使用者名稱
    char mqttPassWord[20];                 // MQTT 使用者密碼
    char deviceID[20];                     // 設備ID
    int mID=1;                             // MQTT message ID
    int mRetain=1;                         // MQTT Retain
    const int tID=MQTT_TCP_ID;             // TCP ID   
    int keepAliveTime=5;                   // MQTT keep live time(秒)
    int _rssi=-113;                        // RSSI
public:  
    nbiot(){};
    nbiot(Stream &srl);
    nbiot(char *apn, char *band, Stream &srl);
    ~nbiot();
    int wakeUp(int times=1,uint32_t intervalTime=300);                                                            // wake up the nbiot device
    int setupNetwork();
    int setupNetwork(char *apn,char *band);
    int checkNetwork(int *rssi);                                                                                 // 確認基地台網路連線狀態, return 0 : 連線成功, return (1,2):未反應, return (3,4) : (sim卡未反應,sim卡未插入), return 5 : 連線失敗,未註冊  
    int checkNetwork();
    int getRSSI(int *errCode=0);
    void setupServer(char *mqIp, char *mqUserName, char *mqPasswd, char *dvID,int keepalive=5);                  // 設定 連接MQTT SERVER資料
    void setupServer(uint16_t mqPort, char *mqIp, char *mqUserName, char *mqPasswd, char *dvID,int keepalive=5); // 設定 連接MQTT SERVER資料
    int start();                                                                                            // start connect MQTT Server  
    int end();                                                                                              // end connect MQTT Server
    int connected();                                                                                        // return 3 connected, return 4 disconnected
    int pub(const char *topic, const char *playload,int mQos=2);                                            // publish a topic
    int sub(const char *topic,int mQos=2);                                                                  // subscribe a topic 
    int getSub(char *t,char *m,uint16_t maxResponeTime=200);                                                // return 1 :recieve a new comming topic & massege, return 0 : no new comming topic & massege
    int getNextSub(char *t,char *m);                                                                        // return 1 :recieve a new comming topic & massege, return 0 : no new comming topic & massege
};

typedef class nbiot nbIOT;

unsigned long differentTime(unsigned long s1,unsigned long s2);

#endif /* _NBIOT_H_ */
