#include <arduino.h>
#include <string.h>
#include "nbiot.h"
#include "DEBUG.h"
#include "difftime.h"

#define led1 PB12  // low 時,LED亮

#define devRst PB1
#define devRstLow() digitalWrite(devRst,LOW)
#define devRstHigh() digitalWrite(devRst,HIGH)
#define led1On() digitalWrite(led1,LOW)
#define led1Off() digitalWrite(led1,HIGH)

#define SensorReadTime 5000               // 5 秒讀一次
unsigned long sensorTimeStamp;

nbIOT mqt(Serial1);

int icnt;

void setup(void) {
    // 設定LED
    pinMode(led1,OUTPUT_OPEN_DRAIN);
    
    pinMode(devRst,OUTPUT);
    Serial.begin(115200);              // 設定host serial for debug or monitor

    led1Off();
    
    devRstHigh();
    delay(300);
    devRstLow();
    delay(1500);
    devRstHigh();
    delay(100);
    
    Serial1.begin(115200);             // 設定MQTT serial for MQTT

    int i;
    for(i=0;i<20;i++){
        led1On();
        delay(200); 
        led1Off();
        delay(200);    
        if (Serial.available()){
            while (Serial.available()) Serial.read(); 
            break;       
        }
    }
    
    led1Off();

    mqt.flush();

    int errCode;
    
    DBG("Setup network!!");
    led1On();
    if (errCode = mqt.setupNetwork("internet.iot","1,8")){        // return 1 if error
        DBG("Setup Network Error %d .",errCode);BRK;
    }else{
        DBG("Setup Network Ok!! delay 1 sec");
        delay(1000);
    }
    DBG("Check Network......");
    int rssi;
    if ((errCode = mqt.checkNetwork(&rssi))!=0) {
        DBG("Check Network Error %d .",errCode);
        BRK;
    }else{
        DBG("Network working is good,RSSI %d dBm",rssi); 
    }
    
    led1Off();

    DBG("Set MQTT server");
    mqt.setupServer("youlight.com.tw","TEST","1357AAAA","NBIOT002",SensorReadTime/1000);    

    DBG("Start MQTT.....");
    if ((errCode = mqt.start())!=0) {
        DBG("Start connection MQTT Server Error %d .",errCode);
        BRK;
    }else{
        DBG("Connection MQTT Server Ok");
    }
    
    mqt.sub("sub_icnt");
    mqt.sub("pub_icnt");
 
    //led2Off();

    icnt=0;
    sensorTimeStamp=millis()-(SensorReadTime/2);
}

char topic[20];
char payload[128];
int errCode;

void loop(void) {
    
    if (differentTime(sensorTimeStamp,millis()) > SensorReadTime){
        sensorTimeStamp = millis();
        if (mqt.connected()){
            DBG("RSSI %d dBm",mqt.getRSSI());
            led1On();
            errCode=mqt.pub("pub_icnt",String(icnt).c_str());
            if (errCode==0){
                DBG("publish pub_icnt %d ok",icnt);
            } else 
                DBG("publish pub_icnt %d fail,error %d",icnt,errCode);
            icnt++;
            led1Off();
        } else {
            if ((errCode = mqt.start())!=0) {
                DBG("Start connection MQTT Server Error %d .",errCode);
            }else{
                DBG("Connection MQTT Server Ok");   
                
                mqt.sub("sub_icnt");
                mqt.sub("pub_icnt"); 
                
                led1On();
                errCode=mqt.pub("pub_icnt",String(icnt).c_str());
                if (errCode==0){
                    DBG("publish pub_icnt %d ok",icnt);
                } else 
                    DBG("publish pub_icnt %d fail,error %d",icnt,errCode);
                icnt++;
                led1Off();
            }
        }
    }
    
    if (mqt.getSub(topic,payload,500)){
        DBG("SUB topic= %s : payload= %s",topic,payload);
        while (mqt.getNextSub(topic,payload))
            DBG("SUB topic= %s : payload= %s",topic,payload);  
        mqt.flush();
    };   
    
}
